<?php
/**
 * 上传、删除插件和模板
 * 兼容 1.3.0
 * @package Upload Plugin
 * @author TypechoTeam
 * @version 2.0.0
 * @dependence 10.6.24-*
 * @link https://Typecho.Team
 */

// 兼容 Typecho 1.3.0 及更早版本的常量和函数
if (!defined('__TYPECHO_ROOT_DIR__')) {
    define('__TYPECHO_ROOT_DIR__', dirname(dirname(dirname(dirname(__FILE__)))));
}
if (!defined('__TYPECHO_PLUGIN_DIR__')) {
    define('__TYPECHO_PLUGIN_DIR__', '/usr/plugins');
}
if (!defined('__TYPECHO_THEME_DIR__')) {
    define('__TYPECHO_THEME_DIR__', '/usr/themes');
}
if (!function_exists('_t')) {
    function _t($str) { return $str; }
}

class UploadPlugin_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        if (!class_exists('ZipArchive')) {
            throw new Typecho_Plugin_Exception(_t('对不起, 您的服务器不支持 ZipArchive 类, 无法正常使用此插件'));
        }

        // 检查目录写权限
        $pluginDir = defined('__TYPECHO_PLUGIN_DIR__') ? __TYPECHO_PLUGIN_DIR__ : '/usr/plugins';
        $rootDir = defined('__TYPECHO_ROOT_DIR__') ? __TYPECHO_ROOT_DIR__ : dirname(dirname(dirname(dirname(__FILE__))));
        if(!is_writable($rootDir . $pluginDir)){
            throw new Typecho_Plugin_Exception(_t('插件目录无写入权限, 无法正常使用此插件'));
        }
        if(!function_exists('file_put_contents') && !function_exists('fopen')){
            throw new Typecho_Plugin_Exception(_t('file_put_contents、fopen函数被禁用, 无法正常使用此插件'));
        }

        // Helper 兼容命名空间
        if (class_exists('Utils\\Helper')) {
            \Utils\Helper::addPanel(1, 'UploadPlugin/panel.php', _t('上传'), _t('在线插件管理'), 'administrator');
            \Utils\Helper::addAction('upload-plugin', 'UploadPlugin_Action');
        } else if (class_exists('Typecho\\Helper')) {
            \Typecho\Helper::addPanel(1, 'UploadPlugin/panel.php', _t('上传'), _t('在线插件管理'), 'administrator');
            \Typecho\Helper::addAction('upload-plugin', 'UploadPlugin_Action');
        } else if (class_exists('Helper')) {
            \Helper::addPanel(1, 'UploadPlugin/panel.php', _t('上传'), _t('在线插件管理'), 'administrator');
            \Helper::addAction('upload-plugin', 'UploadPlugin_Action');
        }
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate()
    {
        // 兼容不同版本的 Helper 类
        if (class_exists('Utils\\Helper')) {
            \Utils\Helper::removeAction('upload-plugin');
            \Utils\Helper::removePanel(1, 'UploadPlugin/panel.php');
        } else if (class_exists('Typecho\\Helper')) {
            \Typecho\Helper::removeAction('upload-plugin');
            \Typecho\Helper::removePanel(1, 'UploadPlugin/panel.php');
        } else if (class_exists('Helper')) {
            \Helper::removeAction('upload-plugin');
            \Helper::removePanel(1, 'UploadPlugin/panel.php');
        }
    }

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){}

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig($form){}

}
